import yaml
from dataclasses import dataclass

@dataclass
class StudyConfig:
    study_id: str
    mode: str
    prestack_csv: str
    prestack_meta_csv: str
    lens_csv: str
    source_fits: str
    apply_m_bias: bool
    use_geometry_norm: bool
    cosmology_name: str
    nz_csv: str
    plateau_slope_abs_max: float
    min_bins: int
    min_b: float
    max_b: float
    use_geo_in_amplitude: bool
    bootstrap_n: int
    random_seed: int
    save_intermediate_per_stack: bool

def load_study_config(path: str) -> 'StudyConfig':
    with open(path,'r') as f:
        y = yaml.safe_load(f)
    return StudyConfig(
        study_id=y['study_id'],
        mode=y['mode'],
        prestack_csv=y.get('prestack_csv',''),
        prestack_meta_csv=y.get('prestack_meta_csv',''),
        lens_csv=y.get('lens_csv',''),
        source_fits=y.get('source_fits',''),
        apply_m_bias=bool(y.get('apply_m_bias', True)),
        use_geometry_norm=bool(y.get('use_geometry_norm', False)),
        cosmology_name=y.get('cosmology_name','Planck15'),
        nz_csv=y.get('nz_csv',''),
        plateau_slope_abs_max=float(y['plateau_slope_abs_max']),
        min_bins=int(y['min_bins']),
        min_b=float(y['min_b']),
        max_b=float(y['max_b']),
        use_geo_in_amplitude=bool(y.get('use_geo_in_amplitude', False)),
        bootstrap_n=int(y['bootstrap_n']),
        random_seed=int(y['random_seed']),
        save_intermediate_per_stack=bool(y.get('save_intermediate_per_stack', True)),
    )
